-------------------------------------------
-- added to make below compile
-------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
entity wait_example is
end wait_example;
-------------------------------------------
ARCHITECTURE wait_example of wait_example IS
  SIGNAL sendB, sendA : std_logic;
BEGIN
  sendA <= '0';
  A : PROCESS
  BEGIN
    WAIT UNTIL sendB = '1';
    sendA <= '1' AFTER 10 ns;

    WAIT UNTIL sendB = '0';
    sendA <= '0' AFTER 10 ns;

  END PROCESS A;

  B : PROCESS
  BEGIN
    WAIT UNTIL sendA = '0';
    sendB <= '0' AFTER 10 ns;

    WAIT UNTIL sendA = '1';
    sendB <= '1' AFTER 10 ns;

  END PROCESS B;
END wait_example;




ARCHITECTURE wait_timeout OF wait_example IS
  SIGNAL sendA, sendB : std_logic;
BEGIN
  A : PROCESS
  BEGIN
    WAIT UNTIL (sendB = '1') FOR 1 us;

    ASSERT (sendB = '1')
      REPORT "sendB timed out at '1'"
      SEVERITY ERROR;

    sendA <= '1' AFTER 10 ns;

    WAIT UNTIL (sendB = '0') FOR 1 us;

    ASSERT (sendB = '0')
      REPORT "sendB timed out at '0'"
      SEVERITY ERROR;

    sendA <= '0' AFTER 10 ns;
  END PROCESS A;

  B : PROCESS
  BEGIN
    WAIT UNTIL (sendA = '0') FOR 1 us;

    ASSERT (sendA =  '0')
      REPORT "sendA timed out at '0'"
      SEVERITY ERROR;

    sendB <= '0' AFTER 10 ns;

    WAIT UNTIL (sendA = '1') FOR 1 us;

    ASSERT (sendA = '1')
      REPORT "sendA timed out at '1'"
      SEVERITY ERROR;

    sendB <= '1' AFTER 10 ns;

  end PROCESS B;
END wait_timeout;

